<?php
// app/Models/Prediksi.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Prediksi extends Model
{
    protected $table = 'prediksi';
    
    protected $fillable = [
        'desa_id', 'dusun_id', 'tanggal_prediksi', 'curah_hujan',
        'kelembapan_tanah', 'tingkat_risiko', 'risiko_score', 
        'rekomendasi', 'data_bmkg'
    ];

    protected $casts = [
        'tanggal_prediksi' => 'date',
        'data_bmkg' => 'array',
    ];

    public function desa()
    {
        return $this->belongsTo(Desa::class);
    }

    public function dusun()
    {
        return $this->belongsTo(Dusun::class);
    }

    public function getRisikoColorAttribute()
    {
        return match($this->tingkat_risiko) {
            'aman' => 'success',
            'waspada' => 'warning',
            'kritis' => 'danger',
            default => 'secondary'
        };
    }
}
